/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections.longs;

/**
 * List of long numbers.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface LongList extends LongCollection {
    int size();
    boolean isEmpty();
    boolean contains(long e);
    LongIterator iterator();
    long[] toArray();
    long[] toArray(long a[]);
    boolean add(long e);
    boolean remove(long e);
    boolean containsAll(LongCollection c);
    boolean addAll(LongCollection c);
    boolean addAll(int index, LongCollection c);
    boolean removeAll(LongCollection c);
    boolean retainAll(LongCollection c);
    void clear();
    boolean equals(Object o);
    int hashCode();

    /**
     * Returns the value at the specified index.
     *
     * @param index the index to retrieve the value from.
     * @return the value at the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    long getAt(int index);

    /**
     * Sets the value at the specified index.
     *
     * @param index the index to set the value at.
     * @param e the new value.
     * @return the value previously present the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    long setAt(int index, long e);

    /**
     * Adds the value at the specified index, and moves elements starting
     * at index to the right.
     *
     * @param index the index to add the value at.
     * @param e the new value.
     * @throws IndexOutOfBoundsException if index < 0 or index > size.
     */
    void addAt(int index, long e);

    /**
     * Removes the value at the specified index, and shifts elements starting
     * at index+1 to the left.
     *
     * @param index the index to remove the value from.
     * @return the value previously present at the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    long removeAt(int index);

    /**
     * Returns the smallest index at which the list contains the specified
     * number.
     * @param e the number to look for
     * @return the smallest index of e
     */
    int indexOf(long e);

    /**
     * Returns the largest index at which the list contains the specified
     * number.
     * @param e the number to look for
     * @return the largest index of e
     */
    int lastIndexOf(long e);

    LongListIterator listIterator();

    LongListIterator listIterator(int index);

    LongList subList(int fromIndex, int toIndex);
}
